<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="./Style/style.css">
    <script src="./Controller/index.js" defer></script>
    <title>Back Office</title>
</head>

<body>
    <header>
        <?php if (connected_user() && !empty($comments)): ?>
            <div class="logo">
                <img src="./uploads/<?= htmlspecialchars($comments['photo_profil']) ?>" alt="Photo de profil">
            </div>
        <?php endif; ?>

        <nav>
            <ul>
                <li><a href="index.php?action=home">Accueil</a></li>
                <li><a href="index.php?action=showArchives">Archives</a></li>
                <?php if (isAdmin()): ?>
                    <li><a href="index.php?action=precreate_post">Ajouter un Billet</a></li>
                    <li><a href="index.php?action=administration">Administration</a></li>
                <?php endif; ?>
            </ul>
        </nav>

        <div class="right-nav">
            <ul>
                <?php if (connected_user()): ?>
                    <li><a href="index.php?action=profile">Mon Profil</a></li>
                <?php else: ?>
                    <li><a href="index.php?action=login">Connexion</a></li>
                    <li><a href="index.php?action=inscription">Inscription</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </header>

    <main>
        <h1 class="backoffice-title">Back Office</h1>
        <hr>

        <div class="backoffice-container">
            
            <!-- Liste des utilisateurs -->
            <section class="left-column">
                <h2 class="section-title">Liste des utilisateurs :</h2>
                <?php foreach (show_users() as $user): ?>
                    <div class="user-item">
                        <p>ID: <?= htmlspecialchars($user['id_utilisateurs']) ?></p>
                        <p>Login: <?= htmlspecialchars($user['login']) ?></p>
                        <p>Prénom: <?= htmlspecialchars($user['prenom']) ?></p>
                        <p>Nom: <?= htmlspecialchars($user['nom']) ?></p>

                        <a href="index.php?action=deleteUser&id=<?= intval($user['id_utilisateurs']) ?>" class="delete-user">Supprimer l'utilisateur</a>
                        <button class="edit-button" onclick="showUpdateForm(<?= $user['id_utilisateurs'] ?>)">Modifier</button>

                        <form action="index.php?action=update_users&id=<?= intval($user['id_utilisateurs']) ?>" method="POST" class="update-form">
                            <label for="login-<?= $user['id_utilisateurs'] ?>">Login :</label>
                            <input type="text" name="login" id="login-<?= $user['id_utilisateurs'] ?>" value="<?= htmlspecialchars($user['login']) ?>" required>
                            <label for="prenom-<?= $user['id_utilisateurs'] ?>">Prénom :</label>
                            <input type="text" name="prenom" id="prenom-<?= $user['id_utilisateurs'] ?>" value="<?= htmlspecialchars($user['prenom']) ?>" required>
                            <label for="nom-<?= $user['id_utilisateurs'] ?>">Nom :</label>
                            <input type="text" name="nom" id="nom-<?= $user['id_utilisateurs'] ?>" value="<?= htmlspecialchars($user['nom']) ?>" required>
                            <button type="submit" class="update-button">Enregistrer</button>
                            <button type="button" onclick="hideUpdateForm(<?= $user['id_utilisateurs'] ?>)">Annuler</button>
                        </form>
                    </div>
                    <hr>
                <?php endforeach; ?>
            </section>

            <!-- Liste des billets -->
            <section class="right-column">
                <h2 class="section-title">Liste des billets :</h2>
                <?php foreach (all_posts() as $post): ?>
                    <div class="post-item">
                        <h3><?= htmlspecialchars($post['titre']) ?></h3>
                        <p><?= htmlspecialchars($post['contenu']) ?></p>
                        <small><?= htmlspecialchars($post['date_post']) ?> - ID: <?= intval($post['id_billets']) ?></small>

                        <?php if (isAdmin()): ?>
                            <a href="index.php?action=delete_post&id=<?= intval($post['id_billets']) ?>" class="delete-post">Supprimer</a>
                            <button class="edit-button" onclick="showPostUpdateForm(<?= $post['id_billets'] ?>)">Modifier</button>

                            <form action="index.php?action=update_post&id=<?= intval($post['id_billets']) ?>" method="POST" class="update-form-post">
                                <label for="titre-<?= $post['id_billets'] ?>">Titre :</label>
                                <input type="text" name="titre" id="titre-<?= $post['id_billets'] ?>" value="<?= htmlspecialchars($post['titre']) ?>" required>
                                <label for="contenu-<?= $post['id_billets'] ?>">Contenu :</label>
                                <textarea name="contenu" id="contenu-<?= $post['id_billets'] ?>" required><?= htmlspecialchars($post['contenu']) ?></textarea>
                                <button type="submit">Enregistrer</button>
                                <button type="button" onclick="hidePostUpdateForm(<?= $post['id_billets'] ?>)">Annuler</button>
                            </form>
                        <?php endif; ?>
                    </div>
                    <hr>
                <?php endforeach; ?>
            </section>

            <!-- Liste des commentaires -->
            <section class="last-column">
                <h2 class="section-title">Liste des commentaires :</h2>
                <?php foreach (all_comments() as $comment): ?>
                    <div class="comments-item">
                        <p><?= htmlspecialchars($comment['contenu']) ?></p>
                        <small><?= htmlspecialchars($comment['date_post']) ?></small>
                        <a href="index.php?action=delete_comments&id=<?= intval($comment['id_commentaires']) ?>" class="delete-post">Supprimer</a>

                        <button onclick="toggleCommentForm(<?= $comment['id_commentaires'] ?>)">Modifier</button>
                        <form action="index.php?action=update_comments&id=<?= intval($comment['id_commentaires']) ?>" method="POST" class="update-comment-form">
                            <label for="contenu-<?= $comment['id_commentaires'] ?>">Contenu :</label>
                            <input type="text" name="contenu" id="contenu-<?= $comment['id_commentaires'] ?>" value="<?= htmlspecialchars($comment['contenu']) ?>" required>
                            <button type="submit">Enregistrer</button>
                            <button type="button" onclick="hideCommentForm(<?= $comment['id_commentaires'] ?>)">Annuler</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            </section>
        </div>
    </main>
</body>

</html>
