<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Accueil</title>
    <link rel="stylesheet" href="EscapeMystere.css">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Stick+No+Bills:wght@200..800&display=swap" rel="stylesheet">

    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Didact+Gothic&display=swap" rel="stylesheet">

</head>
<body>

    <!--BARRE DE NAVIGATION TOP-->
    <header>
        <nav class="top-nav">
        <a href="#main" class="skip-link">Aller au contenu</a>
            <div>
                <a href="index.php">
                    <img src="Images/logo.png" alt="logo">
                </a>
            </div>
            <ul class="contenu">
                <li><a href="index.php">Accueil</a></li>
                <li><a href="salles.php">Salles</a></li>
                <li><a href="Qui_sommes_nous.html">Qui sommes nous ?</a> </li>
            </ul>
        </nav>
    </header>


        <section class="section1">
            <h1 class="titre">ESCAPE</h1>
            <h1 class="titre1">MYSTÈRE</h1>

            <!--CERCLE ANIMÉ-->
            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px"
                y="0px" width="300px" height="300px" viewBox="0 0 300 300" enable-background="new 0 0 300 300"
                xml:space="preserve">
                <defs>
                    <path id="criclePath" d="M75,150A75,75 0 1 1225,150A75,75 0 1 175,150" />
                </defs>

                <circle cx="150" cy="150" r="135" fill="#000000" />
                <g>
                    <text>
                        <textPath aria-label="Your Way, Way Better" xlink:href="#criclePath">→Découvrir→Découvrir
                        </textPath>
                    </text>
                </g>
            </svg>
        </section>



        <?php
        include("connexion.php");

        // Requête SQL pour sélectionner les trois dernières salles ajoutées
        $query = "SELECT * FROM salles ORDER BY id_salles DESC LIMIT 3";
        $stmt = $db->query($query);
        $salles = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>


        <section class="lastsalles">
            <div class="center-text">
                <hr>
                <h2>Nos dernières salles</h2>
                <hr>
            </div>

            <div class="salles-content reveal">
                <?php foreach ($salles as $salle) : ?>
                    <div class="box">
                        <?php
                        $imagePath = 'Images/' . htmlspecialchars($salle['image']);
                        echo "<img src='" . $imagePath . "' alt='" . htmlspecialchars($salle['nom']) . "' />";
                        ?>
                        <h4>Thème : <?php echo htmlspecialchars($salle['theme']); ?></h4>
                        <h3><?php echo htmlspecialchars($salle['nom']); ?></h3> 
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="center-btn">
                <a href="salles.php" class="btn">Voir les salles</a>
            </div>
        </section>


        <main role="main" id="main" tabindex="-1">
         <!--SECTION 2-->
        <section class="section2">
            <hr>
            <h2>Qu'est-ce qu'on propose ?</h2>
            <hr>
            <section class="explication">
                <div class="ligne">
                    <div class="serviceContent">
                        <h3>Qu'est-ce qu'un Escape Game</h3>
                        <p>
                            Un Escape Game est un jeu d'évasion immersif où les participants doivent résoudre des
                            énigmes pour sortir d'une pièce dans un temps limité.</p>

                    </div>
                    <div class="serviceContent">
                        <h3>Notre contenu</h3>
                        <p>
                            Nos salles conviennent aux participants à partir de 8 ans. Nous offrons un choix varié de
                            salles adaptées à vos préférences. </p>
                         
                    </div>

                    <div class="serviceContent">
                        <h3>Réservez dès maintenant !</h3>
                        <p>
                            Plongez dans une aventure captivante et réservez dès maintenant votre salle Escape Game pour
                            une expérience
                            inoubliable entre amis ou en famille !
                        </p>
                    </div>
                </div>

         <img src="Images/clef.png" alt="" class="clef">
 <img src="Images/point_d-interro.png" alt="" class="point">
            </section>
</main>



            <!--SLIDER-->
            <section class="section3">
                <div class="container">
                    <div class="titre-diapo">
                        <h1>RÉSERVEZ</h1>
                        <p class="diapo-reservation">Afin de réserver une salle <a href="reservation.php">cliquez ici !</a>
                        </p>
                    </div>
                    <div class="js-slider" id="decaleGauche">
                        <div class="js-photos">
                            <div class="js-photo" style="background-image: url('Images/chambre_1.jpg');"></div>
                            <div class="js-photo" style="background-image: url('Images/chambre_2.jpg');"></div>
                            <div class="js-photo" style="background-image: url('Images/chambre_3.jpg');"></div>
                            <div class="js-photo" style="background-image: url('Images/chambre_4.jpg');"></div>
                            <div class="js-photo" style="background-image: url('Images/chambre_5.jpg');"></div>
                        </div>
                    </div>
                </div>
                <div class="nav-slider">
                    <button class="prev-btn">&#10094;</button>
                    <button class="next-btn">&#10095;</button>
                </div>
            </section>



    <!--BARRE DE NAVIGATION BOTTOM-->
    <footer>
        <nav class="bottom-nav">
            <ul>
                <li><a href="faq.html">FAQ</a></li>
                <li><a href="plan_du_site.html">Plan du site</a></li>
                <li><a href="mentions_legales.html">Mentions légales</a></li>
            </ul>
        </nav>
    </footer>



     <!--JAVASCRIPT-->
    <script src="EscapeMystere.js"></script>

</body>

</html>